drop table if exists locations cascade;
create table locations
(
    id serial primary key,
    name varchar
);

drop table if exists customers cascade;
create table customers
(
    id serial primary key,
    first_name varchar,
    second_name varchar,
    reachable boolean,
    location_id integer references locations(id)
);

drop table if exists packages cascade;
create table packages
(
    id serial primary key,
    insurance boolean,
    delivery_price numeric,
    status varchar,
    delivery_attempts smallint,
    damage smallint, --- v percentách
    sender_id integer references customers(id),
    recipient_id integer references customers(id),
    check (sender_id != recipient_id)
);

drop table if exists items cascade;
create table items
(
    id serial primary key,
    name varchar,
    weight numeric,
    price numeric,
    uninsured_ratio smallint, --- v percentách
    package_id integer references packages(id)
);

drop table if exists connections cascade;
create table connections
(
    id serial primary key,
    loca_id integer references locations(id),
    locb_id integer references locations(id),
    unique (loca_id, locb_id)
);

drop table if exists transports cascade;
create table transports
(
    id serial primary key,
    route varchar,
    departure_time timestamp,
    arrival_time timestamp,
    package_id integer references packages(id) unique,
    starting_loc_id integer references locations(id),
    destination_loc_id integer references locations(id)
);

drop table if exists segments cascade;
create table segments
(
    id serial primary key,
    transport_id integer references transports(id),
    connection_id integer references connections(id),
    accident boolean,
    damage smallint, --- ak bola nehoda v percentách
    time timestamp
);

drop table if exists drivers cascade;
create table drivers
(
    id serial primary key,
    first_name varchar,
    second_name varchar,
    hire_date date,
    salary numeric,
    initial_salary numeric,
    delivered_packages integer,
    location_id integer references locations(id),
    transport_id integer references transports(id) unique
);